flat varying vec4 labvalue;
flat varying float emissive;

varying vec4 lmtexcoord;
varying vec4 color;
varying vec2 normalMatCompressed;

vec3 normalMat = decodeNormal(normalMatCompressed);

#if defined(LAB_PBR) || defined(POM) || defined(LOD_FIX)
varying vec4 v_MidTile; // .xy = midtex, .zw = tileSize

vec2 midtex = v_MidTile.xy;
vec2 tileSize = v_MidTile.zw;
#endif

#if defined(LAB_PBR) || defined(POM)
varying vec3 normalMat2;
varying vec4 tangent;

    #ifdef POM
        #include "/lib/pom.glsl"
    #endif
#endif

const float DEFAULT_REFLECTANCE = 0.04;
const float EMISSIVE_MAX = 255.0;

#ifndef ENTITY

    #ifdef LAB_PBR
vec4 getSpecularPropertiesLAB(vec2 tcoord, vec3 albedo, float emissive)
{
    vec4 s = texture(specular, tcoord);
    
    float smoothness = s.x;
    float reflectance = (s.y > 0.0) ? s.y : DEFAULT_REFLECTANCE;
    
    float sss;
    if (s.z == 0.0)
    {
        sss = (labvalue.z < 0.0) ? 0.062745098 : (64.5 + 209.55 * labvalue.z) * 0.003922;
    }
    else
    {
        sss = s.z;
    }
    
    float albedoLuma = luma(albedo);
    float emissives = (s.w > 0.0 && s.w < 1.0) ? s.w : emissive * albedoLuma * albedoLuma;
    
    return vec4(sss, emissives, reflectance, smoothness);
}

    #else
vec4 getSpecularPropertiesNonLAB(vec2 tcoord, vec3 albedo, float emissive)
{
    float lumaValue = luma(albedo);
    float lumaSq = lumaValue * lumaValue;
    
    float sss = labvalue.z;
    float emissives = emissive * lumaSq;
    
    #ifdef ENTITY
        if (entityId == 1803) sss = 1.0;
        if (entityId == 1602) emissives = 1.0;
    #endif
    
    // LOD calculation - keep original algorithm
    vec3 albedoLod;
    #ifdef LOD_FIX
        vec2 invTexSize = 1.0 / textureSize(texture, 0);
        vec2 deltaPos = invTexSize * noise_standard(gl_FragCoord.xy) * 4.0;
        
        vec3 accum = texture(texture, midtex).rgb;
        accum += texture(texture, midtex + vec2(deltaPos.x, 0.0)).rgb;
        accum += texture(texture, midtex + vec2(-deltaPos.x, 0.0)).rgb;
        accum += texture(texture, midtex + vec2(0.0, deltaPos.y)).rgb;
        accum += texture(texture, midtex + vec2(0.0, -deltaPos.y)).rgb;
        accum += texture(texture, midtex + deltaPos).rgb;
        accum += texture(texture, midtex - deltaPos).rgb;
        
        albedoLod = accum * (1.0 / 6.0);
    #else
        albedoLod = textureLod(texture, tcoord, 2.0).rgb;
    #endif
    
    float diff = abs(lumaValue - luma(albedoLod));
    float modifier = clamp(pow(diff, 0.25) + sqrt(diff), 0.0, 1.0);
    
    // Consolidate modifier calculations
    float modHigh = labvalue.x * 1.2;
    float modLow = labvalue.x * 0.7;
    float reflectance = mix(modHigh, modLow, modifier);
    
    modHigh = labvalue.y * 1.2;
    modLow = labvalue.y * 0.7;
    float smoothness = mix(modHigh, modLow, modifier);
    
    // Simplify SSS calculation
    if (sss <= 0.0) {
        sss = (16.0 + 47.0 * mix(labvalue.w * 1.2, labvalue.w, modifier)) * (1.0 / 255.0);
    } else {
        sss = (64.5 + 190.5 * mix(sss * 1.2, sss, modifier)) * (1.0 / 255.0);
    }
    
    // Handle high reflectance case
    float hiCond = step(0.9, labvalue.x);
    reflectance = mix(reflectance, labvalue.x, hiCond);
    smoothness = mix(smoothness, clamp(smoothness, 0.0, 1.0), hiCond);
    
    return vec4(sss, emissives, reflectance, smoothness);
}
    #endif // not LAB_PBR

#endif // not ENTITY

// Main function to obtain specular properties - now takes albedo as parameter
vec4 getSpecularProperties(vec2 tcoord, vec3 albedo, float emissive)
{
#ifndef ENTITY
    #ifdef LAB_PBR
        return getSpecularPropertiesLAB(tcoord, albedo, emissive);
    #else
        return getSpecularPropertiesNonLAB(tcoord, albedo, emissive);
    #endif
#else
    return vec4(0.0, 0.0, 0.02, 0.1);
#endif
}

#ifdef GENERATED_NORMALS
    #include "/lib/normal_generator.glsl"
#endif

vec3 calculateNormal(vec2 tcoord, vec2 lmtexcoord, mat3 tbnMatrix, inout float ao)
{
    vec3 normalTex;
    
    vec3 normalout;
#ifdef GENERATED_NORMALS
    normalTex = normalGenerator(lmtexcoord.xy, midtex);
    normalout.xy = normalTex.xy * 2.0 - 0.996078431372549;
    normalout.z = sqrt(clamp(1.0 - dot(normalout.xy, normalout.xy), 0.0, 1.0));

#else
    normalTex = texture(normals, tcoord, 0).rgb;
    ao *= normalTex.b;
    normalout.xy = normalTex.xy * 2.0 - 0.996078431372549;
    normalout.z = sqrt(clamp(1.0 - dot(normalout.xy, normalout.xy), 0.0, 1.0));
#endif

    float bumpmultiplier = BUMP_MULT;
    float bumpmult = (1.0 - wetness * 0.95) * bumpmultiplier;

    normalout = normalout * vec3(bumpmult, bumpmult, bumpmult) + vec3(0.0f, 0.0f, 1.0f - bumpmult);

    normalout = normalize(normalout * tbnMatrix);

    return normalout;
}

vec3 calculateNormalWrapper(vec2 tcoord, inout float ao, vec3 fragpos)
{
    vec3 normal;
    
#ifdef LAB_PBR

    vec3 tangent2 = normalize(cross(tangent.rgb, normalMat2) * tangent.w);
    mat3 tbnMatrix2 = mat3(
        tangent.x, tangent2.x, normalMat2.x,
        tangent.y, tangent2.y, normalMat2.y,
        tangent.z, tangent2.z, normalMat2.z);

    normal = viewToWorld(calculateNormal(tcoord, lmtexcoord.xy, tbnMatrix2, ao));
#else
    normal = normalMat;
#endif

#ifdef NORMAL_FIX
    vec3 cameraVector = normalize(fragpos);
    vec3 vnormal = worldToView(normalMat);
    normal = viewToWorld(faceforward(worldToView(normal), cameraVector, vnormal));
#endif

    return normal;
}

vec2 computeAdvancedLighting(vec2 lightmap, vec3 fragpos, vec3 normal)
{
#ifdef DLM
    vec3 dx = dFdx(fragpos);
    vec3 dy = dFdy(fragpos);
    vec2 derivation = 256.0 * vec2(dFdx(lightmap.x), dFdy(lightmap.x));
    
    vec3 direction = normalize(derivation.x * dx + derivation.y * dy + cross(dx, dy) * 0.01);
    float ndotd = dot(worldToView(normal), direction);
    
    float power = 1.0 - ndotd * lightmap.x;
    float derivationLength = min(length(derivation) * 10.0, 1.0);
    
    lightmap.x = mix(lightmap.x, pow(lightmap.x, power), derivationLength);
#endif

    return lightmap;
}

#ifdef ENTITY
    #ifdef NO_ENTITY_TAA
    /* RENDERTARGETS: 0,2,3,5 */
    #else
    /* RENDERTARGETS: 0,2,3 */
    #endif
#else
/* RENDERTARGETS: 0,2,3 */
#endif

void main()
{
    vec2 tcoord = lmtexcoord.xy;
    vec2 lightmap = lmtexcoord.zw;
    
    vec3 fragpos = toScreenSpace(gl_FragCoord.xyz * vec3(texelSize, 1.0));
    
#ifdef POM
    vec3 pomnormal = normalMat2.rgb;
    tcoord = applyPOM(tcoord, fragpos, pomnormal);
#endif
    
    // Fetch albedo ONCE
    vec4 albedo = texture(texture, tcoord, 0);
    albedo.rgb *= color.rgb;
    float ao = color.a;
    
#ifdef ENTITY
    #ifdef NAMETAG_FIX
    if (entityId == 1600 || entityId == 1500)
    {
        albedo.a *= color.a;
        ao = 1.0;
        albedo.rgb *= 2.0;
    }
    #endif
#endif
    
    // Get material properties using already-fetched albedo
    vec4 materialProps = getSpecularProperties(tcoord, albedo.rgb, emissive);
    
    // Calculate normal
    vec3 normal = calculateNormalWrapper(tcoord, ao, fragpos);
    
    // Additional lighting computations
#ifdef PBR
    lightmap = computeAdvancedLighting(lightmap, fragpos, normal);
    lightmap.x = min(lightmap.x + materialProps.y, 1.0);
#endif
    
    albedo.rgb = toLinear(albedo.rgb);
    
    // Output
    gl_FragData[0] = albedo;
    gl_FragData[1].rgba = vec4(encodeNormal(normal), encodeVec2(lightmap), encodeVec2(vec2(ao, materialProps.x)));
    gl_FragData[2].r = encodeVec2(materialProps.zw);
    
#ifdef ENTITY
    #ifdef NO_ENTITY_TAA
    gl_FragData[3].g = 1.0;
    #endif
#endif
}